/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

import com.melissadata.*;
import java.io.*;

public class PhoneSample {

  public static String the_license = "Place License String Here";
  public static String datafile_dir = "C:\\Program Files\\Melissa Data\\DQT\\Data";
  
  public static void main(String args[]) throws IOException 
  {
    Boolean i;
    String results, latitude, longitude;
	// Create new Phone Object
    mdPhone phoneObj = new mdPhone();
	
	// Create new Global Phone Object
	mdGlobalPhone globalPhoneObj = new mdGlobalPhone();

    // ********************** LICENSE STRINGS ***********************
    //       To unlock the full function ality of Phone Object,   
    //   please call a sales representative at 1-800-MELISSA ext. 3 
    //           (1-800-635-4772 x3) for a license string.          
    //        Without a valid license string, PhoneObject will     
    //               only verify Nevada phone numbers.               
    //              REPLACE "DEMO" with LICENSE STRING                    

    //   SetLicenseString will also check for a valid license in the 
    //   MDPHONE_LICENSE(Environment) variable. This allows you to  
    //   modify the license without recompiling the project
    // **************************************************************


    /* Set License and Datafile path */

    boolean test = phoneObj.SetLicenseString(the_license);
	boolean globalPhoneTest = globalPhoneObj.SetLicenseString(the_license);
    
    // ********************** DATA FILE PATH  ***********************
    //  File location path is set to the default Data File location
    //  Change this value if you installed the data files to a       
    //  different folder.                                            
    //  The Data Files Directory must contain the following files:   
    //  mdAddr.dat, mdPhone.dat, mdPhone.idx, and ZIPNPA.txt
    // **************************************************************


    //Initialize Data Files
    mdPhone.ProgramStatus result = phoneObj.Initialize(datafile_dir);
	mdGlobalPhone.ProgramStatus globalPhoneResult = globalPhoneObj.Initialize(datafile_dir);

    //Print Initialization Status Results
    System.out.println("==============  Phone Obj Initialization Info  =============");
    System.out.println("  Set License: " + test);
    System.out.println(" Build number: " + phoneObj.GetBuildNumber());
    System.out.println("Database Date: " + phoneObj.GetDatabaseDate());
	
	System.out.println("===========  Global Phone Obj Initialization Info  ==========");
    System.out.println("  Set License: " + globalPhoneTest);
    System.out.println(" Build number: " + globalPhoneObj.GetBuildNumber());
    System.out.println("Database Date: " + globalPhoneObj.GetDatabaseDate());

    if (result != mdPhone.ProgramStatus.ErrorNone)
    {
      //Problem during initialization
      System.out.println("Initialization Error: " + phoneObj.GetInitializeErrorString());
      return;
    }
	
    if (globalPhoneResult != mdGlobalPhone.ProgramStatus.ErrorNone)
    {
      //Problem during initialization
      System.out.println("Initialization Error: " + globalPhoneObj.GetInitializeErrorString());
      return;
    }
    
	String globalPhoneNum = "";
	String globalPhoneCountry = "";
	String globalPhoneCountryOrigin = "";
	
    String input = "";
    String phone = "";
    String zip = "";
	
	String type = "";
	
    BufferedReader stdin = new BufferedReader( new InputStreamReader( System.in ) );
    while (!input.equals("X"))
    {
	  type = "";
	  System.out.print("\n Verify an international number (Y/N)?:");
	  type = stdin.readLine();
	  
	  if(type.equals("Y"))
	  {
		System.out.print("\nEnter telephone (ex: 422304850): ");
		globalPhoneNum = stdin.readLine();
		System.out.print("\nEnter country (ex: JPN): ");
		globalPhoneCountry = stdin.readLine();
		System.out.print("\nEnter country of origin (ex: USA): ");
		globalPhoneCountryOrigin = stdin.readLine();
		
		// Process the Phone Number
		globalPhoneObj.Lookup(globalPhoneNum,globalPhoneCountry,globalPhoneCountryOrigin);
		
		// Get returned properties of the Global Phone Number
		
		System.out.println("\n==================Lookup Result===================");
		  System.out.println("               Phone Number: " + globalPhoneObj.GetPhoneNumber());
		  System.out.println("		 International Prefix: " + globalPhoneObj.GetInternationalPrefix());
		  System.out.println("              Nation Prefix: " + globalPhoneObj.GetNationPrefix());
		  System.out.println("  National Destination Code: " + globalPhoneObj.GetNationalDestinationCode());
		  System.out.println("            Locality (City): " + globalPhoneObj.GetLocality());
		  System.out.println("Administrative Area (State): " + globalPhoneObj.GetAdministrativeArea());
		  System.out.println("                    Country: " + globalPhoneObj.GetCountry());
		  System.out.println("                County Code: " + globalPhoneObj.GetCountryCode());
		  System.out.println("                        DST: " + globalPhoneObj.GetDST());
		  System.out.println("                   Language: " + globalPhoneObj.GetLanguage());
		  System.out.println("                   Latitude: " + globalPhoneObj.GetLatitude());
		  System.out.println("                  Longitude: " + globalPhoneObj.GetLongitude());
		  System.out.println("          Subscriber Number: " + globalPhoneObj.GetSubscriberNumber());
		  System.out.println("                        UTC: " + globalPhoneObj.GetUTC());
		  
		  results = globalPhoneObj.GetResults();
	  }
      else{
		  System.out.print("\nEnter Telephone:");
		  phone = stdin.readLine();
		  System.out.print("      Enter Zip:");
		  zip = stdin.readLine();

		  // Process the Phone Number 
		  phoneObj.Lookup(phone,zip);

		  // Get returned properties of the Phone Number / Zip Code

		  System.out.println("\n==================Lookup Result===================");
		  System.out.println("    Area Code: " + phoneObj.GetAreaCode());
		  System.out.println("       Prefix: " + phoneObj.GetPrefix());
		  System.out.println("       Suffix: " + phoneObj.GetSuffix());
		  System.out.println("    Extension: " + phoneObj.GetExtension());
		  System.out.println("         City: " + phoneObj.GetCity());
		  System.out.println("        State: " + phoneObj.GetState());
		  System.out.println("  County Name: " + phoneObj.GetCountyName());
		  System.out.println("  County Fips: " + phoneObj.GetCountyFips());
		  System.out.println(" Country Code: " + phoneObj.GetCountryCode());
		  System.out.println("     Timezone: " + phoneObj.GetTimeZone());
		  System.out.println("Timezone Code: " + phoneObj.GetTimeZoneCode());
		  System.out.println("          MSA: " + phoneObj.GetMsa());
		  System.out.println("         PMSA: " + phoneObj.GetPmsa());
		  
		  results = phoneObj.GetResults();
		  
		  
		  if(results.contains("PS01") || results.contains("PS02"))
		  {
			// Using the latitude and longitude of a valid phone number,
			// Phone Object can also compute the Distance and Bearing to another location
			System.out.println("");
			latitude = phoneObj.GetLatitude();
			longitude = phoneObj.GetLongitude();
			System.out.println(" Latitude: " + latitude);
			System.out.println("Longitude: " + longitude);
			System.out.println("\n");
			System.out.println("==================================================");
			System.out.println(" Compute Distance and Bearing to another location");
			System.out.println(" Lat / Long of US Capital: 38.889722  -77.0075 ");
			System.out.println("==================================================");
			System.out.println("     Distance : " + (phoneObj.ComputeDistance(Double.valueOf(latitude), Double.valueOf(longitude), 38.889722, -77.0075)) + " miles");
			System.out.println("      Bearing : " + (phoneObj.ComputeBearing(Double.valueOf(latitude), Double.valueOf(longitude), 38.889722, -77.0075)) + " degrees\n\n");
		  
		  }
		  		  
		  if(!zip.trim().equals(""))
		  {
			phoneObj.CorrectAreaCode(phone,zip);
			System.out.println("\n==============Correct Area Code Result=============");
			System.out.println("    Area Code: " + phoneObj.GetAreaCode());
			System.out.println("New Area Code: " + phoneObj.GetNewAreaCode());
		  }
		  
		}
		
		// Results Codes are returned for the phone number's properties or errors
		System.out.println("\n==================Results Codes===================");
		if(results.contains("PS01"))
		  System.out.println("PS01: Phone validated to 10 digits");
		if(results.contains("PS02"))
		  System.out.println("PS02: Phone validated to 7 digits");
			if(results.contains("PS07"))
		  System.out.println("PS07: Exchange Type... Cellular");
		if(results.contains("PS08"))
		  System.out.println("PS08: Exchange Type... Land Line");
		if(results.contains("PS09"))
		  System.out.println("PS09: Exchange Type... Voip");
		if(results.contains("PS10"))
		  System.out.println("PS10: Phone Type...... Residential");
		if(results.contains("PS11"))
		  System.out.println("PS11: Phone Type...... Business");
		if(results.contains("PS12"))
		  System.out.println("PS12: Phone Type...... Small/Home Office");
		if(results.contains("PS06"))
			  System.out.println("PS06: New Area Code Furnished");

		if (results.contains("PE01"))
		  System.out.println("PE01: Bad Area Code");
		if(results.contains("PE02"))
		  System.out.println("PE02: Blank Phone Number");
		if(results.contains("PE03"))
		  System.out.println("PE03: Too few or too many digits");
		if(results.contains("PE04"))
		  System.out.println("PE04: Multiple Match");
		if(results.contains("PE05"))
		  System.out.println("PE05: Bad prefix");
		if(results.contains("PE06"))
		  System.out.println("PE06: Bad Zip Code");
		
		System.out.print("\nPress Enter to Continue, X to quit:");
		  input = stdin.readLine().toUpperCase();
	  }
	  phoneObj.delete();
	  
	}
}
